<?php

namespace app\money\model;

use think\helper\Hash;
use app\money\model\Role as RoleModel;
use think\model;
use think\Db;

class EsopPlanRecord extends Model
{

    // 设置当前模型对应的完整数据表名称
    protected $table = '__ESOP_PLAN_RECORD__';


    public static function  getAll($map = [], $order = '')
    {
        $data_list = self::view('esop_plan_record pr', true)
            ->view('member', 'mobile, name, id_card', 'member.id=pr.mid', 'left')
            ->view('stock_list', 'title', 'stock_list.id=pr.stock_id', 'left')
            ->where($map)
            ->order($order)
            ->paginate()
            ->each(function ($item, $key) {
                $item->affect = money_convert($item->affect);
                $item->surplus = money_convert($item->surplus);
            });

        return $data_list;
    }

    /**
     *获取期权明细记录列表
     * @author  2024-06-20
     */
    public static function getEsopPlanRecordList($where = [], $order = 'id asc',$offset,$pagesize)
    {
        $esop_plan_record_list = self::view('esop_plan_record epr', "id,mid,stock_id,stock_trust_id,affect,surplus,heatos,type,info")
            ->view("stock_list sl", 'title,code', 'sl.id=epr.stock_id', 'left')
            ->field(["FROM_UNIXTIME(epr.create_time,'%Y-%m-%d %T')" => 'create_time'])
            ->where($where)
            ->order($order)
            ->page($offset, $pagesize)
            ->select();
        return $esop_plan_record_list;
    }
}
