<?php

namespace app\money\admin;

use app\admin\controller\Admin;
use app\common\builder\ZBuilder;
use app\money\model\EsopPlan as EsopPlanModel;
use app\member\model\Member as MemberModel;
use app\stock\model\StockList as StockListModel;
use think\Db;
use think\Hook;
use think\Cache;

/**
 * 期权计划管理控制器
 * @package app\money\admin
 */
class Esopplan extends Admin
{
    /**
     * 首页
     * @return mixed
     */
    public function index()
    {
        cookie('__forward__', $_SERVER['REQUEST_URI']);
        // 获取查询条件
        $map = $this->getMap();
        $order = $this->getOrder();
        empty($order) && $order = 'id desc';
        // 数据列表
        $data_list = EsopPlanModel::getAll($map, $order);
        // 分页数据 
        $page = $data_list->render();

        if (empty($_SERVER["QUERY_STRING"])) {
            $excel_url = substr(http() . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"], 0, -5) . "_export";
        } else {
            $excel_url = substr(http() . $_SERVER["SERVER_NAME"] . $_SERVER["PHP_SELF"], 0, -5) . "_export?" . $_SERVER["QUERY_STRING"];
        }
        $btn_excel = [
            'title' => '导出EXCEL表',
            'icon'  => 'fa fa-fw fa-download',
            'href'  => url($excel_url, '', '')
        ];

        return ZBuilder::make('table')
            ->setSearch(['mid' => '用户ID', 'member.name' => '姓名', 'member.mobile' => '手机号']) // 设置搜索框
            ->addColumns([ // 批量添加数据列
                ['id', 'ID'],
                ['mobile', '手机号'],
                ['name', '姓名'],
                ['title', '股票'],
                ['account', '可用期权'],
                ['plan_account', '期权总值'],
                ['remain_account', '待释放'],
                ['release_account', '已释放'],
                ['duration', '总释放天数'],
                ['days', '已释放天数'],
                ['release_time', '开始释放时间'],
                ['create_time', '创建时间', 'datetime'],
                ['status', '状态', 'switch'],
            ])
            ->hideCheckbox()
            ->setTableName('esop_plan')
            ->addTopButton('custem', $btn_excel)
            ->addTopButtons('add')
            ->addRightButton('edit')
            ->addRightButton('delete')
            ->addOrder('id,create_time,release_time')
            ->setRowList($data_list)
            ->fetch(); // 渲染模板
    }
    /**
     * 新增
     * @return mixed
     */
    public function add()
    {
        // 保存数据
        if ($this->request->isPost()) {
            $data = $this->request->post();
            $data['create_time'] = time();
            $data['plan_account'] = $data['plan_account'] * 100;
            $data['remain_account'] = $data['plan_account'] * 100;
            $data['create_ip'] = get_client_ip(1);
            //业务逻辑处理
            $result_up = Db::name("esop_plan")->insert($data);
            if ($result_up === 1) {
                $this->success('添加成功',  'index');
            } else {
                $this->error($result_up);
            }
        }
        // 使用ZBuilder快速创建表单
        return ZBuilder::make('form')
            ->setPageTitle('新增') // 设置页面标题
            ->addFormItems([ // 批量添加表单项
                ['select:5', 'mid', '请选择用户', '', MemberModel::getMemberList(), '', url('get_mid'), 'mid'],
                ['select:5', 'stock_id', '请选择股票', '', StockListModel::getStockList(), '', url('get_stock_id'), 'stock_id'],
                ['number', 'plan_account', '期权总值', '期权总的价值（港元）', '0'],
                ['number', 'duration', '总释放天数', '总释放天数', '1000'],
                ['datetime', 'release_time', '开始时间', '从哪天开始释放期权', '', 'YYYY-MM-DD HH:mm:ss'],
            ])
            ->fetch();
    }

    // 根据所有用户ID
    public function get_mid($mid)
    {
        $arr = [];
        $where['status'] = 1;
        $where['id'] = $mid;
        $data_list = Db::name('member')->where($where)->find();
        if (!is_null($data_list)) {
            $arr['code'] = '1'; //判断状态
            $arr['msg'] = '请求成功'; //回传信息
            $result[$data_list['id']] = $data_list['id'];
            $arr['list'] = format_linkage($result); //将一维数组转成联动需要的数据格式
        } else {
            $arr['code'] = '0'; //判断状态
            $arr['msg'] = '数据请求失败'; //回传信息
            $arr['list'] = []; //将一维数组转成联动需要的数据格式
        }

        return json($arr);
    }
    // 根据所有股票ID
    public function get_stock_id($stock_id)
    {
        $arr = [];
        $where['status'] = 1;
        $where['id'] = $stock_id;
        $data_list = Db::name('stock_list')->where($where)->find();
        if (!is_null($data_list)) {
            $arr['code'] = '1'; //判断状态
            $arr['msg'] = '请求成功'; //回传信息
            $result[$data_list['id']] = $data_list['id'];
            $arr['list'] = format_linkage($result); //将一维数组转成联动需要的数据格式
        } else {
            $arr['code'] = '0'; //判断状态
            $arr['msg'] = '数据请求失败'; //回传信息
            $arr['list'] = []; //将一维数组转成联动需要的数据格式
        }

        return json($arr);
    }
}
