<?php

namespace app\money\model;

use think\helper\Hash;
use app\money\model\Role as RoleModel;
use app\money\model\EsopPlanRecord as EsopPlanRecordModel;
use app\money\model\Withdraw as MoneyWithdrawModel;
use app\member\model\Bank as BankModel;
use app\member\model\MemberMessage as MemberMessageModel;
use think\model;
use think\Db;

class EsopPlan extends Model
{

    // 设置当前模型对应的完整数据表名称
    protected $table = '__ESOP_PLAN__';


    public static function  getAll($map = [], $order = '')
    {
        $data_list = self::view('esop_plan p', true)
            ->view('member', 'mobile, name, id_card', 'member.id=p.mid', 'left')
            ->view('stock_list', 'title', 'stock_list.id=p.stock_id', 'left')
            ->where($map)
            ->order($order)
            ->paginate()
            ->each(function ($item, $key) {
                $item->account = money_convert($item->account);
                $item->plan_account = money_convert($item->plan_account);
                $item->remain_account = money_convert($item->remain_account);
                $item->release_account = money_convert($item->release_account);
            });

        return $data_list;
    }

    /**
     *获取期权计划列表
     * @author  2024-06-20
     */
    public static function getEsopPlanList($where = [], $order = 'id asc', $offset, $pagesize = 15)
    {
        $esop_plan_list = self::view('esop_plan ep', 'id,mid,account,plan_account,release_account,remain_account,release_time')
            ->view("stock_list sl", 'title,code', 'sl.id=ep.stock_id', 'left')
            ->field(["CONCAT(ROUND(release_account / plan_account * 100, 2), ' % ')" => 'accuracy'])
            ->field(["FROM_UNIXTIME(ep.create_time,'%Y-%m-%d %T')" => 'create_time'])
            ->where($where)
            ->order($order)
            ->page($offset, $pagesize)
            ->select();
        return $esop_plan_list;
    }
    /**
     * 期权提现
     */
    public static function esopWithdraw($parameter)
    {
        $bank_id = $parameter['bank_id'];
        $bank = BankModel::bankInfo($bank_id); //银行卡信息
        $where1['id'] = $parameter['mid']; //会员ID
        $where1['status'] = 1; //会员状态
        $names = Db::name('member')->field('name')->where($where1)->find(); //用户基本信息
        //组合提现记录
        $data['bank'] = $bank['bank'] . "|" . $bank['card'] . '|' . $bank['province'] . $bank['city'] . $bank['branch'] . "|" . $names['name'];
        $data['mid'] = $parameter['mid'];
        $data['money'] = $parameter['money'] * 100;
        $data['fee'] = $parameter['money'] * 100 * config('withdraw_rate');
        $data['order_no'] = 'tx' . generate_rand_str(10, 3);
        $data['create_time'] = time();
        $data['create_ip'] = get_client_ip(0);

        Db::startTrans();
        //查看当前期权的信息
        $money_info = self::where(['id' => $data['esop_plan_id']])->find();
        //计算余额
        $account = bcsub($money_info['account'], $data['money']);

        try {
            $res1 = MoneyWithdrawModel::create($data);
            //写入期权变化明细表
            $arr = [
                'mid' => $parameter['mid'],
                'stock_id' => $parameter['stock_id'],
                'esop_plan_id' => $parameter['esop_plan_id'],
                'affect' => $parameter['money'],
                'surplus' => $account,
                'heatos' => -1,
                'type' => 3,
                'info' => "期权申请提现，金额：" . $parameter['money'],
                'create_time' => time(),
                'create_ip' => get_client_ip(0)
            ];
            $res2 = EsopPlanRecordModel::create($arr);
            //更新期权信息
            $res3 = self::where('id', $parameter['esop_plan_id'])->update('account', $account);
            if ($res1 && $res2 && $res3) {
                Db::commit();
                return ['status' => 1, 'message' => '提交成功'];
            } else {
                Db::rollback();
                return ['status' => 0, 'message' => '提交失败'];
            }
        } catch (\Exception $e) {
            Db::rollback();
            return ['status' => 0, 'message' => '数据异常'];
        }
    }
}
