<?php
// +----------------------------------------------------------------------
// | 常量定义表
// +----------------------------------------------------------------------

// 定义上传目录
define('DS', DIRECTORY_SEPARATOR);
define('UPLOAD_DIR', dirname(__DIR__) . DIRECTORY_SEPARATOR . 'public/uploads');
define('WS_SERVER_IP', (isset($this->request->server()['REMOTE_ADDR']) ? $this->request->server()['REMOTE_ADDR'] : ''));
/**
 * 系统常量
 * -- TOKEN_EXPIRE_TIME           用户登陆超时时间
 * -- SEARCH_CACHE_EXPIRE_TIME    搜索缓存过期时间
 * -- LOCAL_STOCK_TIMES           每隔几秒获取一次
 * -- LOCAL_STOCK_COUNT           每次获取股票个数
 * -- LOCAL_TRADING_TOKEN         行情数据请求TOKEN
 * -- LOCAL_STOCK_HOST            行情数据请求地址
 * -- LOCAL_STOCK_PORT            行情数据端口
 * -- TRUST_ACTIVE_TIME           自动撤单时间，默认10分钟
 * -- TRUST_MODEL_TIME............交易模式（T+1：1 ；T+0：0）
 */
define('TOKEN_EXPIRE_TIME', 60*60*24);//600   ------60*60*24=1天
define('SEARCH_CACHE_EXPIRE_TIME', 60*60*24);//1天
define('LOCAL_STOCK_TIMES', 3);//单位：秒
define('LOCAL_STOCK_COUNT', 800);
define('LOCAL_TRADING_TOKEN', 'cRQEEFzjDXASltkjvprHiBOSiNZNtRXP');
define('LOCAL_STOCK_HOST', 'stock.fcv3.1776174838209647.cn-hangzhou.fc.devsapp.net');
define('LOCAL_STOCK_PORT', 80);
define('TRUST_ACTIVE_TIME', 10*60);//默认10分钟
define('TRUST_MODEL_TIME', 1);// T+1：1 ; T+0：0
/**
 * 定义Redis服务器常量
 * -- REDIS_SERVER_IP        服务器IP地址
 * -- REDIS_SERVER_PASSWORD  密码
 */
define('REDIS_SERVER_IP', '127.0.0.1');
define('REDIS_SERVER_PORT', 6379);
/**
 * 根据type 获取资金明细的交易类型
 */
define('MONET_TYPE_NAME', [
    '1'=>'充值成功',
    '2'=>'提现冻结',
    '3'=>'提现成功',
    '4'=>'提现失败',
    '5'=>'撤销提现',
    '6'=>'提现退回',
    '7'=>'追加保证金',
    '8'=>'冻结保证金',
    '9'=>'返还保证金',
    '10'=>'邀请人推广返佣',
    '11'=>'代理商佣金入账',
    '12'=>'代理商分成入账',
    '13'=>'提取佣金',
    '14'=>'提取分成',
    '15'=>'终止配资',
    '16'=>'配资管理费',
    '17'=>'递延费',
    '18'=>'后台转账',
    '19'=>'管理员操作',
    '20'=>'配资结算',
    '21'=>'配资审核不通过',
    '22'=>'配资审核通过',
    '23'=>'申请配资续期',
    '24'=>'扩大配资审核通过',
    '25'=>'扩大配资审核未通过',
    '26'=>'追加保证金审核通过',
    '27'=>'追加保证金审核未通过',
    '28'=>'配资续期审核通过',
    '29'=>'配资续期审核未通过',
    '30'=>'配资提前终止审核通过',
    '31'=>'配资提前终止审核未通过',
    '32'=>'按月配资手续费自动扣款',
    '33'=>'冻结金额',
    '34'=>'扣除金额',
    '80'=>'自动续期系统扣款',
    '85'=>'提取盈利'
]);

define('RECORD_TYPE_NAME',[
    '1'=>'购买股票扣款',
    '2'=>'卖出股票回款',
    '3'=>'购买股票扣款',
    '4'=>'卖出股票回款',
    '5'=>'卖出成功解除冻结',
    '6'=>'买入成功解除冻结',
    '7'=>'扣费用',
    '8'=>'买入撤单解除冻结',
    '9'=>'卖出撤单解除冻结',
    '10'=>'追加保证金',
    '11'=>'扩大配资',
    '12'=>'提取盈利',
    '13'=>'股票分红',
    '14'=>'股票除权',
    '15'=>'代扣股票利息税',    
]);
