<?php

namespace app\apicom\home;

use app\money\model\EsopPlan as EsopPlanModel;
use app\money\model\EsopPlanRecord as EsopPlanRecordModel;
use think\db;
use think\Request;
use think\helper\Hash;

class Esop extends Common
{
    /**
     * 期权计划
     * @return [type] [description]
     */
    public function getEsopPlanList()
    {
        if (!MID) ajaxmsg('登陆后才能进行查询', 0);
        // 获取查询条件
        $map = $this->getMap();
        $map['mid'] = MID;
        $order = 'id desc';
        $page = intval($this->request->param("page"));
        $page = $page ? $page : 1;
        $offset = $page;
        // 数据列表
        $data_list = EsopPlanModel::getEsopPlanList($map, $order, $offset);
        foreach ($data_list as $k => $v) {
            $data_list[$k]['release_account'] = bcdiv($v['release_account'], 100, 2);
            $data_list[$k]['plan_account'] = bcdiv($v['plan_account'], 100, 2);
            $data_list[$k]['remain_account'] = bcdiv($v['remain_account'], 100, 2);
            $data_list[$k]['account'] = bcdiv($v['account'], 100, 2);
        }

        ajaxmsg('数据列表', 1, $data_list);
    }

    /**
     * 期权计划
     * @return [type] [description]
     */
    public function getEsopPlanRecordList()
    {
        if (!MID) ajaxmsg('登陆后才能进行查询', 0);
        // 获取查询条件
        $map = $this->getMap();
        $map['mid'] = MID;
        $order = 'id desc';
        //期权计划ID
        $esop_plan_id = intval($this->request->param("esop_plan_id"));
        if ($esop_plan_id) {
            $map['esop_plan_id'] = $esop_plan_id;
        }
        $page = intval($this->request->param("page"));
        $page = $page ? $page : 1;
        $offset = $page;
        // 数据列表
        $data_list = EsopPlanRecordModel::getEsopPlanRecordList($map, $order, $offset, 15);
        foreach ($data_list as $k => $v) {
            $data_list[$k]['affect'] = bcdiv($v['affect'], 100, 2);
            $data_list[$k]['surplus'] = bcdiv($v['surplus'], 100, 2);
            $data_list[$k]['type'] = getTypeNameForEsop($v['type']);
            $data_list[$k]['stock'] = [];
            if ($v['stock_trust_id']) {
            }
        }

        ajaxmsg('数据列表', 1, $data_list);
    }
    /**
     * 查询可提现期权
     * @return [type] [description]
     */
    public function getEsopPlanForWithdraw()
    {
        if (!MID) ajaxmsg('登陆后才能进行查询', 0);
        // 获取查询条件
        $map = $this->getMap();
        $map['mid'] = MID;
        $order = 'id desc';
        // 数据列表
        $data_list = EsopPlanModel::view('esop_plan ep', 'id,account')
            ->view('stock_list', 'title', 'stock_list.id=ep.stock_id', 'left')
            ->where(['ep.account' => ['>', 0], 'ep.mid' => MID, 'ep.status' => 1])
            ->select();
        foreach ($data_list as $k => $v) {
            $data_list[$k]['account'] = bcdiv($v['account'], 100, 2);
        }
        ajaxmsg('数据列表', 1, $data_list);
    }
    /*
     * 操作提现操作
     */
    public function doWithdraw()
    {
        $data = [];
        //银行卡id
        $data['bank_id'] = $this->request->param('bank_id');
        //用户id
        $data['mid'] = MID;
        //提现申请金额
        $data['money'] = $this->request->param("money");
        //期权计划id
        $data['esop_plan_id'] = $this->request->param("esop_plan_id");
        if (!$data['esop_plan_id']) {
            ajaxmsg('请选择要提现的期权！', 0);
        }
        //提现规则基本校验
        $result = $this->validate($data, "Withdraw.create");
        if (true !== $result) {
            ajaxmsg($result, 0);
        }
        if ($data['money'] < 0) {
            ajaxmsg('提现金额错误！', 0);
        }
        //校验当前期权计划余额
        $money_res = EsopPlanModel::where(['id' => $data['esop_plan_id']])->find();
        if (empty($money_res['account']) || ($money_res['account'] <= 0)) {
            ajaxmsg('查询账户资金出错！', 0);
        }
        if (isset($money_res['account']) && $money_res['account'] < $data['money']) {
            ajaxmsg('提现金额已经大于可用余额！', 0);
        }
        //查询是否已申请过提现，一次只能有一笔提现
        $withdraw_info = Db::name('money_withdraw')
            ->where(['mid' => MID])
            ->where(['status' => 0])
            ->find();
        if (!empty($withdraw_info)) {
            ajaxmsg('您已有提现申请，请耐心等待审核。', 0);
        }
        //校验支付密码
        $c = Db::name('member')->where(["id" => MID])->find();
        if (Hash::check((string)$data['paywd'], $c['paywd'])) {
            $res = EsopPlanModel::esopWithdraw($data);
        } else {
            ajaxmsg('支付密码错误', 0);
        }
        if ($res['status']) {
            ajaxmsg('提现申请已提交，请耐心等待审核', 1);
        } else {
            ajaxmsg('提现申请提交失败', 0);
        }
    }
}
