import { createApp } from 'vue'
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import 'element-plus/theme-chalk/display.css'
import sent from './sent'
import i18n from './locales'
import router from './router'
import store from './store'
import App from './App.vue'

const app = createApp(App);

app.use(i18n);
app.use(store);
app.use(router);
app.use(ElementPlus);
app.use(sent);

//挂载app
app.mount('#app');
