import config from "@/config"
import http from "@/utils/request"

export default {
	version:{
		url: `${config.API_URL}system/index/version`,
		name: "获取最新版本号",
		get: async function(){
			return await http.get(this.url);
		}
	},
	clearcache: {
		url: `${config.API_URL}system/index/clearcache`,
		name: "清除缓存",
		post: async function(){
			return await http.post(this.url);
		}
	},
	info: {
		url: `${config.API_URL}system/index/info`,
		name: "系统信息",
		get: function(data){
			return http.get(this.url, data);
		}
	},
	setting:{
		list: {
			url: `${config.API_URL}system/setting/index`,
			name: "获取配置信息",
			get: function(params){
				return http.get(this.url, params);
			}
		},
		fields: {
			url: `${config.API_URL}system/setting/fields`,
			name: "获取配置字段",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}system/setting/add`,
			name: "保存配置信息",
			post: function(data){
				return http.post(this.url, data);
			}
		},
		edit: {
			url: `${config.API_URL}system/setting/edit`,
			name: "编辑配置信息",
			post: function(data){
				return http.put(this.url, data);
			}
		},
		save: {
			url: `${config.API_URL}system/setting/save`,
			name: "保存配置信息",
			post: function(data){
				return http.put(this.url, data);
			}
		}
	},
	dictionary: {
		category: {
			url: `${config.API_URL}system/dict/category`,
			name: "获取字典树",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		editcate:{
			url: `${config.API_URL}system/dict/editcate`,
			name: "编辑字典树",
			post: async function(data = {}){
				return await http.put(this.url, data);
			}
		},
		addcate:{
			url: `${config.API_URL}system/dict/addcate`,
			name: "添加字典树",
			post: async function(data = {}){
				return await http.post(this.url, data);
			}
		},
		delCate:{
			url: `${config.API_URL}system/dict/deletecate`,
			name: "删除字典树",
			post: async function(data = {}){
				return await http.delete(this.url, data);
			}
		},
		list: {
			url: `${config.API_URL}system/dict/lists`,
			name: "字典明细",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		get: {
			url: `${config.API_URL}system/dict/detail`,
			name: "获取字典数据",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		edit:{
			url: `${config.API_URL}system/dict/edit`,
			name: "编辑字典明细",
			post: async function(data = {}){
				return await http.put(this.url, data);
			}
		},
		add:{
			url: `${config.API_URL}system/dict/add`,
			name: "添加字典明细",
			post: async function(data = {}){
				return await http.post(this.url, data);
			}
		},
		delete:{
			url: `${config.API_URL}system/dict/delete`,
			name: "删除字典明细",
			post: async function(data = {}){
				return await http.delete(this.url, data);
			}
		},
		detail: {
			url: `${config.API_URL}system/dict/detail`,
			name: "字典明细",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		alldic: {
			url: `${config.API_URL}system/dict/all`,
			name: "全部字典",
			get: async function(params){
				return await http.get(this.url, params);
			}
		}
	},
	area: {
		list: {
			url: `${config.API_URL}system/area/index`,
			name: "地区列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}system/area/add`,
			name: "地区添加",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}system/area/edit`,
			name: "地区编辑",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
	},
	app: {
		list: {
			url: `${config.API_URL}system/app/list`,
			name: "应用列表",
			get: async function(){
				return await http.get(this.url);
			}
		}
	},
	log: {
		list: {
			url: `${config.API_URL}system/log/index`,
			name: "日志列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		my: {
			url: `${config.API_URL}system/log/my`,
			name: "我的日志",
			get: async function(params){
				return await http.get(this.url, params);
			}
		}
	},
	crontab: {
		list: {
			url: `${config.API_URL}system/crontab/index`,
			name: "定时任务列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}system/crontab/add`,
			name: "定时任务添加",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}system/crontab/edit`,
			name: "定时任务编辑",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}system/crontab/delete`,
			name: "定时任务删除",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		log: {
			url: `${config.API_URL}system/crontab/log`,
			name: "定时任务日志",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		reload: {
			url: `${config.API_URL}system/crontab/reload`,
			name: "定时任务重载",
			post: async function(params){
				return await http.post(this.url, params);
			}
		}
	},
	sms: {
		count: {
			url: `${config.API_URL}system/sms/count`,
			name: "短信发送统计",
			get: async function(params){
				return await http.get(this.url, params);
			}
		}
	}
}
