import config from "@/config"
import http from "@/utils/request"

export default {
	cart: {
        list:{
            url: `${config.API_URL}order/cashier/index`,
			name: "购物车列表",
			get: async function(data){
				return await http.get(this.url, data);
			}
        },
        edit: {
			url: `${config.API_URL}order/cashier/edit`,
			name: "修改购物车",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
        delete: {
			url: `${config.API_URL}order/cashier/delete`,
			name: "删除购物车产品",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}order/cashier/add`,
			name: "添加购物车",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
    }
}