import config from "@/config"
import http from "@/utils/request"

export default {
	list: {
		url: `${config.API_URL}ads/index`,
		name: "获得广告列表",
		get: async function(params){
			return await http.get(this.url, params);
		}
	},
	add: {
		url: `${config.API_URL}ads/add`,
		name: "添加广告",
		post: async function(params){
			return await http.post(this.url, params);
		}
	},
	edit: {
		url: `${config.API_URL}ads/edit`,
		name: "编辑广告",
		post: async function(params){
			return await http.put(this.url, params);
		}
	},
	delete: {
		url: `${config.API_URL}ads/delete`,
		name: "删除广告",
		post: async function(params){
			return await http.delete(this.url, params);
		}
	}
}