<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Wechat\Listeners;

use Modules\Order\Events\OrderRefund;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Modules\Wechat\Services\PayService;

class OrderRefundListener implements ShouldQueue{

	public function handle(OrderRefund $event){
		$refund = $event->refund;
		$order = $event->order;
		$detail = $event->detail;

		app(PayService::class)->refund($order, $refund, $detail);
	}
}