<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Services;

use Modules\System\Models\Dict;
use Modules\System\Models\DictGroup;
use App\Support\Tree;

class DictService {

	/**
	 * @title 获取列表数据
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request) {
		$map = [];

		if ($request->filled('title')) {
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if ($request->filled('name')) {
			$map[] = ['group_name', '=', $request->input('name')];
		}
		if ($request->filled('group_id')) {
			$map[] = ['group_id', '=', $request->input('group_id')];
		}

		$query = Dict::where($map)->orderBy('sort', 'asc')->orderBy('id', 'desc');

		if($request->filled('page')){
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}else{
			$data = $query->get();
		}
		return $data;
	}

	/**
	 * @title 字段分类数据
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getCategoryList($request){
		$map = [];

		if ($request->filled('title')) {
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if ($request->filled('name')) {
			$map[] = ['name', 'like', '%' . $request->input('name') . '%'];
		}

		$query = DictGroup::where($map)->orderBy('id', 'desc');


		if($request->filled('is_tree') && $request->filled('is_tree') == 1){
			$query = $query->get()->toArray();
			$tree = new Tree();
			$data = $tree->list_to_tree($query, 0, 'id', 'parent_id');
		}else{
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->limit($request->input('limit', 10))->offset($request->input('page', 1) - 1)->get(),
			];
		}
		return $data;
	}

	/**
	 * @title 创建字典
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function create($request){
		$request->validate([
			'title' => 'required'
		]);
		$group_name = DictGroup::where('id', '=', $request->input('group_id'))->value('name');

		$request->merge(['group_name' => $group_name]);

		$dict = new Dict;
		foreach ($dict->setFilterFields($request->all()) as $key => $value) {
			$dict->$key = $value;
		}

		if($dict->values == ''){
			$dict->values = $dict->id;
		}
		$dict->save();
		return $dict;
	}

	/**
	 * @title 更新字典
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function update($request){
		try {
			$dict = Dict::findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("改字典不存在", 1);
		}

		if ($request->filled('title')) {
			$dict->title = $request->input('title');
		}
		if ($request->filled('values')) {
			$dict->values = $request->input('values');
		}
		if ($request->filled('sort')) {
			$dict->sort = $request->input('sort');
		}
		if ($request->filled('status')) {
			$dict->status = $request->input('status');
		}
		if ($request->filled('group_id')) {
			$dict->group_id = $request->input('group_id');
			$dict->group_name = DictGroup::where('id', '=', $request->input('group_id'))->value('name');
		}

		$dict->save();
		return $dict;
	}

	/**
	 * @title 删除字典
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function delete($request){
		try {
			$dict = Dict::findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("改字典不存在", 1);
		}

		$dict->delete();
		return $dict;
	}

	/**
	 * @title 创建字典分类
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function createCategory($request){
		$request->validate([
			'title' => 'required|unique:system_dict_groups',
			'name' => 'required|unique:system_dict_groups',
		]);

		$data = $request->all();
		$data['status'] = 1;
		$group = DictGroup::create($data);

		return $group;
	}

	/**
	 * @title 更新字典分类
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function updateCategory($request){
		try {
			$dict = DictGroup::findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("改字典不存在", 1);
		}

		if ($request->filled('parent_id')) {
			$dict->parent_id = $request->input('parent_id');
		}
		if ($request->filled('title')) {
			$dict->title = $request->input('title');
		}
		if ($request->filled('name')) {
			$dict->name = $request->input('name');
		}
		if ($request->filled('sort')) {
			$dict->sort = $request->input('sort');
		}
		if ($request->filled('status')) {
			$dict->status = $request->input('status');
		}

		$dict->save();
		return $dict;
	}

	/**
	 * @title 删除字典
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function deleteCategory($request){
		try {
			$dict = DictGroup::findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("改字典不存在", 1);
		}

		$dict->delete();
		return $dict;
	}

	public function getDictionaryAll(){
		$map = [];

		$map[] = ['status', '=', 1];

		$list = Dict::where($map)->get();

		$data = [];
		foreach ($list as $key => $value) {
			$data[$value['group_name']][] = $value;
		}
		return $data;
	}
}
