<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\Auth\Services\MenuService;

class StoreDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void {
		$this->initMenu();
    }

	public function initMenu() {
		$permissions = [
			['title' => '店铺', 'name' => 'goods', 'path' => '/store', 'component' => '', 'type' => 'menu', 'sort' => 3, 'children' => [
				['title' => '店铺列表', 'name' => 'store.lists', 'path' => '/store/lists', 'component' => 'store/lists', 'type' => 'menu'],
				['title' => '分类列表', 'name' => 'store.category', 'path' => '/store/category', 'component' => 'store/category', 'type' => 'menu'],
			]]
		];
		return app(MenuService::class)->importMenu($permissions, 0);
	}
}
