<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
		Schema::create('store', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('店铺名称');
			$table->unsignedBigInteger('service_id')->default(0)->comment('所属分仓');
			$table->unsignedBigInteger('member_id')->comment('用户ID');
			$table->unsignedBigInteger('invite_uid')->default(0)->comment('推广人ID');
			$table->unsignedBigInteger('category_id')->default(0)->comment('分类ID');
			$table->string('name')->nullable()->comment('店主名称');
			$table->string('mobile')->nullable()->comment('联系电话');
			$table->string('province')->nullable()->comment('省');
			$table->string('city')->nullable()->comment('市');
			$table->string('area')->nullable()->comment('区');
			$table->string('address')->nullable()->comment('店铺地址');
			$table->string('license')->nullable()->comment('店铺营业执照');
			$table->string('logo')->nullable()->comment('店铺logo');
			$table->string('description')->nullable()->comment('店铺描述');
			$table->string('cover')->nullable()->comment('店铺封面');
			$table->string('seal')->nullable()->comment('店招');
			$table->text('photos')->nullable()->comment('店铺介绍照片');
			$table->text('store_images')->nullable()->comment('店铺实拍');
			$table->string('latitude')->nullable()->comment('纬度');
			$table->string('longitude')->nullable()->comment('经度');
			$table->text('content')->nullable()->comment('店铺介绍');
			$table->decimal('per_capita', total: 10, places: 2)->default(0)->comment('人均消费');
			$table->decimal('balance_rate', total: 10, places: 2)->default(0)->comment('分润比例');
			$table->decimal('balance_service_rate', total: 10, places: 2)->default(0)->comment('分仓服务费比例');
			$table->decimal('pay_rate', total: 10, places: 2)->default(0)->comment('收款码现金积分比例');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('店铺表');
		});
		Schema::create('store_category', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('分类标题');
			$table->string('description')->nullable()->comment('分类描述');
			$table->string('cover')->nullable()->comment('分类封面');
			$table->string('sort')->default(0)->comment('排序');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('店铺分类表');
		});
		Schema::create('store_goods', function (Blueprint $table) {
			$table->unsignedBigInteger('store_id')->comment('店铺ID');
			$table->unsignedBigInteger('goods_id')->comment('商品ID');
			$table->primary(['store_id', 'goods_id']);

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('店铺商品表');
		});

	}
    /**
     * Reverse the migrations.
     */
    public function down(): void {
		Schema::dropIfExists('store');
		Schema::dropIfExists('store_category');
		Schema::dropIfExists('store_goods');
	}
};
