<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Services;

use Modules\Store\Models\Merchant;

class MerchantService {

	public function getDataList($request){
		$map = [];

		$query = Merchant::where($map)->orderBy('id', 'desc');

		if($request->filled('page')){
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}else{
			$data = $query->limit($request->input('limit',30))->get();
		}
		return $data;
	}

	public function create($request){
		$merchant = new Merchant();

		foreach ($merchant->setFilterFields($request->all()) as $key => $value) {
			$merchant->$key = $value;
		}

		$merchant->save();

		return $merchant;
	}

	public function update($request){
		$merchant = Merchant::findOrFail($request->input('id'));

		foreach ($merchant->setFilterFields($request->all()) as $key => $value) {
			$merchant->$key = $value;
		}

		$merchant->save();

		return $merchant;
	}
}
