<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Store\Services\PaymentService;
use Modules\Wechat\Services\WechatService;

class Payment extends BaseController {

	public function lists(Request $request, PaymentService $service){
		try {
			$member = auth('api')->user();
			$request->merge(['store_master' => $member['uid']]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function detail(Request $request, PaymentService $service){
	}

	public function add(Request $request, PaymentService $service){
		try {
			$request->validate([
				'store_id' => 'required',
				'amount' => 'required',
				'integral' => 'required',
			], [
				'store_id.required' => '请选择店铺',
				'amount.required' => '请输入金额',
				'integral.required' => '请输入积分',
			]);
			$this->data['data'] = $service->create(store_id: $request->input('store_id'), amount: $request->input('amount'), integral: $request->input('integral'), remark: $request->input('remark'));
		} catch (\Throwable $e) {
			$this->data['code'] = 0;
			$this->data['message']  = $e->getMessage();
		}
		return $this->data;
	}

	/**
	 * @title 获取支付二维码
	 *
	 * @param Request $request
	 * @param WechatService $service
	 * @return void
	 */
	public function qrcode(Request $request, WechatService $service){
		try {
			$this->data['data'] = $service->getPaymentQrcode($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 转账
	 *
	 * @param Request $request
	 * @param PaymentService $service
	 * @return void
	 */
	public function transfer(Request $request, PaymentService $service){
		try {
			$this->data['data'] = $service->userTransfer($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function receive(Request $request, PaymentService $service){
		try {
			$this->data['data'] = $service->receiveAccount($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}