<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Store\Services\CategoryService;

class Category extends BaseController {

    /**
     * @title 获取店铺合作伙伴
     *
     * @param Request $request
     * @param CategoryService $service
     * @return void
     */
    public function index(Request $request, CategoryService $service){
        try {
            $this->data['data'] = $service->getDataList($request);
        } catch (\Throwable $th) {
            $this->data['code'] = 1;
            $this->data['message'] = $th->getMessage();
        }
        return $this->data;
    }
}
