<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;

Route::name('order.')->prefix('order')->middleware(['auth.check:api'])->group(function () {
	Route::controller(Modules\Order\Controllers\Api\Order::class)->prefix('order')->name('order.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::get('/lists', 'lists')->name('lists');
		Route::get('/detail', 'detail')->name('detail');
		Route::post('/add', 'add')->name('add');
		Route::post('/simple', 'simple')->name('simple');
		Route::put('/edit', 'edit')->name('edit');
		Route::put('/number', 'number')->name('number');
		Route::delete('/delete', 'delete')->name('delete');
		Route::put('/cancel', 'cancel')->name('cancel');
		Route::post('/take', 'take')->name('take');
		Route::post('/send', 'send')->name('send');
		Route::post('/scan', 'scan')->name('scan');
		Route::put('/refund', 'refund')->name('refund');
		Route::post('/paycheck', 'paycheck')->name('paycheck');
		Route::post('/addaddress', 'addaddress')->name('addaddress');
	});
	Route::controller(Modules\Order\Controllers\Api\Refund::class)->prefix('refund')->name('refund.')->group(function () {
		Route::get('/lists', 'index')->name('lists');
		Route::post('/add', 'add')->name('add');
		Route::get('/detail', 'detail')->name('detail');
	});

	Route::controller(Modules\Order\Controllers\Api\Cart::class)->prefix('cart')->name('cart.')->group(function () {
		Route::get('/lists', 'index')->name('lists');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Order\Controllers\Api\Exchange::class)->prefix('exchange')->name('exchange.')->group(function () {
		Route::post('/add', 'add')->name('add');
	});
});
