<?php

namespace Modules\Member\Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\Auth\Services\MenuService;

class MemberSeeder extends Seeder {
	/**
	 * Run the database seeds.
	 */
	public function run(): void {
		$this->addMemberMenu();
	}

	/**
	 * @title 商品菜单导入
	 *
	 * @return void
	 */
	public function addMemberMenu(){
		$permissions = [
			['title' => '会员', 'name' => 'member', 'path' => '/member', 'component' => '', 'type' => 'menu', 'sort' => 1, 'children' => [
				['title' => '会员列表', 'name' => 'member.lists', 'path' => '/member/lists', 'component' => 'member/lists', 'type' => 'menu'],
				['title' => '会员等级', 'name' => 'member.level', 'path' => '/member/level', 'component' => 'member/level', 'type' => 'menu'],
				['title' => '会员账单', 'name' => 'member.account', 'path' => '/member/account', 'component' => 'member/account', 'type' => 'menu'],
				['title' => '会员积分', 'name' => 'member.score', 'path' => '/member/score', 'component' => 'member/score', 'type' => 'menu'],
				['title' => '签约申请', 'name' => 'member.sign', 'path' => '/member/sign', 'component' => 'member/sign', 'type' => 'menu'],
			]]
		];
		return app(MenuService::class)->importMenu($permissions, 0);
	}
}
