<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
	/**
	 * Run the migrations.
	 */
	public function up(): void {
		Schema::create('member_collect', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('member_id')->comment('用户ID')->index('member_id');
			$table->unsignedBigInteger('goods_id')->default(0)->comment('商品ID')->index('goods_id');
			$table->unsignedBigInteger('store_id')->default(0)->comment('店铺ID')->index('store_id');
			$table->string('type', 20)->default('goods')->comment('收藏类型 goods商品 store店铺')->index('type');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('用户收藏表');
		});

		Schema::create('member_address', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('member_id')->comment('会员id');
			$table->string('name')->comment('收货人');
			$table->string('mobile')->comment('手机号');
			$table->string('province')->nullable()->comment('省');
			$table->string('province_code')->nullable()->comment('省code');
			$table->string('city')->nullable()->comment('市');
			$table->string('city_code')->nullable()->comment('市code');
			$table->string('area')->nullable()->comment('区');
			$table->string('area_code')->nullable()->comment('区code');
			$table->string('address')->comment('详细地址');
			$table->string('postcode')->nullable()->comment('邮编');
			$table->tinyInteger('is_default')->default(0)->comment('是否默认 1是 2否');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员地址表');
		});
		Schema::create('member_account', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('member_id')->comment('会员id');
			$table->unsignedBigInteger('order_id')->comment('订单ID');
			$table->unsignedBigInteger('store_id')->comment('店铺ID');
			$table->string('type', '20')->nullable()->comment('类型');
			$table->string('account_type', '20')->nullable()->comment('账单类型');
			$table->string('pay_type', '20')->nullable()->comment('支付类型');
			$table->decimal('amount', total: 10, places: 2)->default(0)->comment('金额');
			$table->decimal('bf_amount', total: 10, places: 2)->default(0)->comment('前金额');
			$table->decimal('af_amount', total: 10, places: 2)->default(0)->comment('后金额');
			$table->decimal('fee_rate', total: 10, places: 2)->default(0)->comment('手续费率');
			$table->decimal('actual_amount', total: 10, places: 2)->default(0)->comment('实际金额');
			$table->integer('bank_id')->default(0)->comment('提现银行卡ID');
			$table->string('remark', 255)->nullable()->comment('备注');
			$table->string('request_no', 100)->nullable()->comment('请求号,提现时使用');
			$table->tinyInteger('status')->default(1)->comment('状态 0未用，1已转账，2已提现，3提现记录');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');
			$table->string('bank_realname', 255)->nullable()->comment('真实姓名');
			$table->string('reason', 255)->nullable()->comment('申请理由');
			$table->string('out_batch_no', 255)->nullable()->comment('商家批次单号');
			$table->string('detail_status', 255)->nullable()->comment('单号查询状态');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员表账户表');
		});
		Schema::create('member_score', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('member_id')->comment('会员id');
			$table->unsignedBigInteger('order_id')->comment('订单ID');
			$table->unsignedBigInteger('store_id')->comment('店铺ID');
			$table->string('type', '20')->nullable()->comment('类型');
			$table->string('account_type', '20')->nullable()->comment('账单类型');
			$table->decimal('amount', total: 10, places: 2)->default(0)->comment('数量');
			$table->decimal('bf_amount', total: 10, places: 2)->default(0)->comment('前数量');
			$table->decimal('af_amount', total: 10, places: 2)->default(0)->comment('后数量');
			$table->string('remark', 255)->nullable()->comment('备注');
			$table->tinyInteger('status')->default(1)->comment('状态 0未用，1已核销');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员积分表');
		});
		Schema::create('member_bank', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('member_id')->comment('会员id');
			$table->string('name', 100)->comment('姓名');
			$table->string('mobile', 15)->comment('手机号码');
			$table->string('bank_name', 50)->comment('银行名称');
			$table->string('bank_card', 50)->comment('银行卡号');
			$table->string('request_no', 100)->nullable()->comment('请求号,提现时使用');
			$table->string('link_id', 100)->nullable()->comment('银行卡链接id');
			$table->string('auth_sn', 50)->nullable()->comment('认证编号');
			$table->string('status', 10)->default('wait')->comment('状态:wait-待审核,pass-审核通过,reject-审核拒绝');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员银行卡表');
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void {
		Schema::dropIfExists('member_collect');
		Schema::dropIfExists('member_address');
		Schema::dropIfExists('member_account');
		Schema::dropIfExists('member_score');
		Schema::dropIfExists('member_bank');
	}
};
