<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Models;

use App\Models\BaseModel;

class MemberScore extends BaseModel {

	protected $table = 'member_score';
	protected $fillable = ['store_id', 'order_id', 'member_id', 'type', 'amount', 'bf_amount', 'af_amount', 'status', 'remark'];
	// protected $hidden = ['deleted_at'];

	public function member() {
		return $this->belongsTo(Member::class, 'member_id', 'uid');
	}

	public function admin(){
		return $this->belongsTo(\Modules\Auth\Models\Admin::class, 'member_id', 'uid');
	}

	public function order(){
		return $this->belongsTo(\Modules\Order\Models\OrderItem::class, 'order_id', 'id');
	}
}
