<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Listeners;

use Modules\Member\Events\Registered;
use Modules\Member\Models\Member;
use Modules\Member\Models\MemberSocial;

class UpdateMember {

	/**
	 * @title 会员登录后更新用户信息
	 *
	 * @param LoginEvent $event
	 * @return void
	 */
	public function handle(Registered $event) {
		$member = $event->member;
		$social = $event->social;
		$type = $event->type;
		// 三方登录绑定用户

		$social->member_id = $member['uid'];
		$social->save();

		// 更新用户信息
		$member->level_id = 1;
		$member->save();
	}
}
