<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\AuthService;

class Login extends BaseController {

	/**
	 * @title 登录
	 *
	 * @param Request $request
	 * @param AuthService $service
	 * @return void
	 */
	public function index(Request $request, AuthService $service){
		try {
			$this->data['data'] = $service->userLogin($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 退出
	 *
	 * @param Request $request
	 * @param AuthService $service
	 * @return void
	 */
	public function logout(Request $request, AuthService $service){
		try {
			$this->data['data'] = $service->userLogout($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 注册
	 *
	 * @param Request $request
	 * @param AuthService $service
	 * @return void
	 */
	public function register(Request $request, AuthService $service){
		try {
			$this->data['data'] = $service->userRegister($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 获取当前登录用户信息
	 *
	 * @return void
	 */
	public function user(){
		$type = request('type', 'wechat');
		$user = auth('api')->user();

		$user['social'] = $user->social()->where('type', '=', $type)->first();
		$user['level'] = $user->level()->first();
		$user['is_master'] = \Modules\Store\Models\Store::where('member_id', $user->uid)->where('status', 1)->exists();
		$this->data['data'] = $user;
		return response()->json($this->data);
	}
}
