import Request from 'luch-request'
import store from '../store'
import sys_config from '../config'

const http = new Request();

/**
 * @description 修改全局默认配置
 * @param {Function}
*/
http.setConfig((config) => { /* config 为默认全局配置*/
	config.baseURL = sys_config.baseUrl;
	// 设置请求头，支持所有请求头设置，也可不设置，去掉header就行
	config.header = {
		'content-type': 'application/json',
	};
	config.sslVerify = false;
	return config
})


/**
 * @param { Function} cancel - 取消请求,调用cancel 会取消本次请求，但是该函数的catch() 仍会执行; 不会进入响应拦截器
 *
 * @param {String} text ['handle cancel'| any] - catch((err) => {}) err.errMsg === 'handle cancel'。非必传，默认'handle cancel'
 * @cancel {Object} config - catch((err) => {}) err.config === config; 非必传，默认为request拦截器修改之前的config
 * function cancel(text, config) {}
 */
http.interceptors.request.use((config) => {
	config.header = {
		...config.header,
		Authorization: "bearer " + store.state.user.token || ''
	}
	return config
}, config => { // 可使用async await 做异步操作
  return Promise.reject(config)
})

http.interceptors.response.use((response) => { /* 对响应成功做点什么 （statusCode === 200），必须return response*/
	// if (response.data.code != 1) { // 服务端返回的状态码不等于200，则reject()
	// 	uni.showToast({
	// 		icon: 'none',
	// 		title: response.data.message,
	// 		duration: 1500
	// 	});
	// }
	if(response.data.code == 2001 || response.data.code == 2000){
		store.dispatch('userLogout');
	}
	return response.data
}, (response) => { /*  对响应错误做点什么 （statusCode !== 200），必须return response*/
	if(response.statusCode == 502){
		uni.showToast({
			icon: 'none',
			title: '网络连接失败！',
			duration: 1500
		});
	}else if(response.statusCode == 404){
		uni.showToast({
			icon: 'none',
			title: '404 Not Found',
			duration: 1500
		});
	}else{
		uni.showToast({
			icon: 'none',
			title: response.message,
			duration: 1500
		});
	}
	return Promise.reject(response)
})

export default http
