import tool from '../../utils/tool'

export default{
	state: {
		isLogin: tool.data.get('is-login') || false,
		token: tool.data.get('token') || '',
		userInfo: tool.data.get('userInfo') || {name: '', avatar: ''}
	},
	mutations:{
		setUserLogin(state, data){
			if(data){
				tool.data.set('is-login', true);
				state.isLogin = true;
				tool.data.set('token', data.access_token);
				state.token = data.access_token;
			}else{
				tool.data.set('is-login', false);
				tool.data.set('token', '');
				state.isLogin = false;
			}
		},
		setUserInfo(state, data){
			if(data){
				tool.data.set('userInfo', data)
				state.userInfo = data
			}else{
				tool.data.set('userInfo', {})
				state.userInfo = {}
			}
		}
	},
	getters:{},
	actions:{
		userLogout({commit}){
			commit('setUserLogin', false);
			let pages = getCurrentPages()
			tool.data.set('beforLoginUrl', {route: pages[pages.length - 1].route, options: pages[pages.length - 1].options})
			uni.reLaunch({
				url: '/pages/ucenter/login/index'
			})
		}
	}
}
