import http from '@/utils/request'
import config from '@/config'

export default{
	login: {
		url: 'api/member/login',
		name: '登录',
		post: async function(params){
			return await http.post(this.url, params)
		}
	},
	logout: {
		url: 'api/member/logout',
		name: '退出登录',
		post: async function(params){
			return await http.post(this.url, params)
		}
	},
	lists: {
		user: {
			url: 'api/member/user',
			name: '会员信息',
			get: async function(params){
				return await http.get(this.url, {params: params})
			}
		}
	},
	wechat: {
		auth: config.baseUrl + 'api/social/wechat',
		login: {
			url: 'api/wechat/login',
			name: '微信用户信息',
			post: async function(params){
				return await http.post(this.url, params)
			}
		}
	}
}
