import config from "@/config"
import http from "@/utils/request"

export default{
	lists: {
		list: {
			url: `${config.API_URL}goods/index/index`,
			name: "获得商品列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}goods/index/add`,
			name: "添加商品",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}goods/index/edit`,
			name: "编辑商品",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}goods/index/delete`,
			name: "删除商品",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		},
		operate: {
			url: `${config.API_URL}goods/index/operate`,
			name: "商品营销表单",
			get: async function(params){
				return await http.get(this.url, params);
			}
		}
	},
	category: {
		list: {
			url: `${config.API_URL}goods/category/index`,
			name: "获得商品分类列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}goods/category/add`,
			name: "添加商品分类",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}goods/category/edit`,
			name: "编辑商品分类",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}goods/category/delete`,
			name: "删除商品分类",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	brand: {
		list: {
			url: `${config.API_URL}goods/brand/index`,
			name: "获得商品品牌列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}goods/brand/add`,
			name: "添加商品品牌",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}goods/brand/edit`,
			name: "编辑商品品牌",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}goods/brand/delete`,
			name: "删除商品品牌",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	spec: {
		list: {
			url: `${config.API_URL}goods/spec/index`,
			name: "获得商品规格列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}goods/spec/add`,
			name: "添加商品规格",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}goods/spec/edit`,
			name: "编辑商品规格",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}goods/spec/delete`,
			name: "删除商品规格",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	}
}
