import config from "@/config"
import http from "@/utils/request"

export default {
	login: {
		url: `${config.API_URL}auth/login`,
		name: "登录获取TOKEN",
		post: async function(data={}){
			return await http.post(this.url, data);
		}
	},
	logout:{
		url: `${config.API_URL}auth/logout`,
		name: "登出",
		get: async function(data={}){
			return await http.get(this.url, data);
		}
	},
	user: {
		url: `${config.API_URL}auth/user`,
		name: "获取当前登录用户",
		get: async function(data={}){
			return await http.get(this.url, data);
		}
	},
	users: {
		list: {
			url: `${config.API_URL}auth/users/index`,
			name: "获得用户列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}auth/users/add`,
			name: "添加用户",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}auth/users/edit`,
			name: "编辑用户",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		uppasswd:{
			url: `${config.API_URL}auth/users/passwd`,
			name: "修改密码",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		uprole: {
			url: `${config.API_URL}auth/users/uprole`,
			name: "设置角色",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}auth/users/delete`,
			name: "删除用户",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	role: {
		list: {
			url: `${config.API_URL}auth/role/index`,
			name: "获得角色列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}auth/role/add`,
			name: "添加角色",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}auth/role/edit`,
			name: "编辑角色",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		auth: {
			url: `${config.API_URL}auth/role/auth`,
			name: "角色授权",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}auth/role/delete`,
			name: "删除角色",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	department: {
		list: {
			url: `${config.API_URL}auth/department/index`,
			name: "获得部门列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}auth/department/add`,
			name: "添加部门",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}auth/department/edit`,
			name: "编辑部门",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}auth/department/delete`,
			name: "删除部门",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	menu: {
		myMenus: {
			url: `${config.API_URL}auth/menu/my`,
			name: "获取我的菜单",
			get: async function(){
				return await http.get(this.url);
			}
		},
		list: {
			url: `${config.API_URL}auth/menu/index`,
			name: "获取菜单",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}auth/menu/add`,
			name: "添加菜单",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}auth/menu/edit`,
			name: "编辑菜单",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}auth/menu/delete`,
			name: "删除菜单",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
}
