<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;
use Modules\Wechat\Controllers\Api\Index;

Route::post('/wechat/login', [Index::class, 'login']);
Route::post('/wechat/oauth', [Index::class, 'oauth']);
Route::get('serve', [Index::class, 'serve']);

Route::name('wechat.')->prefix('wechat')->middleware(['auth.check:api'])->group(function () {
	Route::get('jssdk', [Index::class, 'jssdk']);

	Route::get('phone', [Index::class, 'phone']);
	Route::get('qrcode', [Index::class, 'qrcode']);

	Route::controller(Modules\Wechat\Controllers\Api\Pay::class)->prefix('pay')->name('pay.')->group(function () {
		Route::post('miniapp', 'miniapp')->name('miniapp');
	});
});
Route::post('/wechat/pay/nativepc', [Modules\Wechat\Controllers\Api\Pay::class, 'nativepc']);

Route::post('/wechat/notify/order', [Modules\Wechat\Controllers\Api\Notify::class, 'order']);
Route::post('/wechat/notify/payment', [Modules\Wechat\Controllers\Api\Notify::class, 'payment']);
Route::post('/wechat/notify/refund', [Modules\Wechat\Controllers\Api\Notify::class, 'refund']);
Route::get('/wechat/notify/transfer', [Modules\Wechat\Controllers\Api\Notify::class, 'transfer']);