<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Wechat\Services;

use Illuminate\Support\Facades\Config;
use EasyWeChat\OfficialAccount\Application;

class MessageService {
	/**
	 * 发送模板消息
	 * @param $openid
	 * @param $template_id
	 * @param $url
	 * @param $data
	 * @return mixed
	 */
	public function sendMessage($openid, $template_id, $url, $data){
		$config = Config::get('wechat.wx');
		$app = new Application($config);
		$client = $app->getClient();

		$result = $client->postJson('/cgi-bin/message/template/send', [
			'touser' => $openid,
			'template_id' => $template_id,
			'url' => $url,
			'data' => $data
		]);
		return $result;
	}
}
