<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Wechat\Listeners;

use Modules\Store\Events\PaySuccess;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Modules\Wechat\Services\ShippingService;

class StorePaymentSuccess implements ShouldQueue{

	/**
	 * 任务应该被处理的时间（秒）。
	 *
	 * @var int
	 */
	public $delay = 60;
	public function handle(PaySuccess $event){
		$payment = $event->payment;

		app(ShippingService::class)->pushShipping($payment->order_no, $payment->member_id, $payment->payment_remark, 3);
		return true;
	}
}