<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Wechat\Listeners;

use Modules\Order\Events\OrderSend;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Modules\Wechat\Models\MemberSocial;
use Modules\Wechat\Services\ShippingService;

class OrderSendPush implements ShouldQueue{

    /**
     * 任务应该被处理的时间（秒）。
     *
     * @var int
     */
    public $delay = 60;
	public function handle(OrderSend $event){
		$order = $event->order;
		$item = $event->item;

		app(ShippingService::class)->pushShipping($order->order_no, $item->member_id, $item->title);
		return true;
	}
}