<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Wechat\Controllers\Api;

use Illuminate\Http\Request;
use Modules\Wechat\Services\OauthService;
use Modules\Wechat\Services\WechatService;
use App\Http\Controllers\BaseController;

class Index extends BaseController {

	/**
	 * 获取微信用户授权跳转
	 */
	public function oauth(Request $request, OauthService $service){
		if($request->filled('code')){
			if($request->filled('url')){
				return redirect($request->input('url') . '?code=' . $request->input('code', ''));
			}
		}else{
			$res = $service->oauth($request);
			return redirect($res);
		}
	}

	/**
	 * @title 微信登录
	 *
	 * @param Request $request
	 * @param OauthService $service
	 * @return void
	 */
	public function login(Request $request, OauthService $service){
		$type = $request->input('type', 'wechat');
		if($request->filled('code')){
			$info = [];
			switch ($type) {
				case 'wechat':
					try {
						$info = $service->wechatLogin($request->input('code', ''));
					} catch (\Throwable $th) {
						$this->data['message'] = $th->getMessage();
						$this->data['code'] = 0;
					}
					break;
				case 'miniapp':
					try {
						$info = $service->mpLogin($request);
					} catch (\Throwable $th) {
						$this->data['message'] = $th->getMessage();
						$this->data['code'] = 0;
					}
					break;
				default:
					$this->data['message'] = "非法操作！";
					$this->data['code'] = 0;
					break;
			}

			if(isset($info['member_id']) && $info['member_id']){
				$token = auth('api')->tokenById($info['member_id']);
				if($token){
					$this->data['data'] = [
						'access_token' => $token,
						'token_type' => 'bearer',
						'expires_in' => auth('api')->factory()->getTTL() * 60
					];
				}elseif(isset($info['openid']) && $info['openid']){
					$member = app(\Modules\Member\Services\AuthService::class)->userRegister($request, $info, $type);

					$token = auth('api')->tokenById($member->uid);
					if($token){
						$this->data['data'] = [
							'access_token' => $token,
							'token_type' => 'bearer',
							'expires_in' => auth('api')->factory()->getTTL() * 60
						];
					}else{
						$this->data['message'] = "登录失败！";
						$this->data['code'] =0;
					}
				}else{
					$this->data['message'] = "登录失败！";
					$this->data['code'] = 0;
				}
			}else{
				if(isset($info['openid']) && $info['openid']){
					$request->merge([
						'nickname' => $info['nickname'],
						'username' => $info['openid'],
						'password' => uniqid()
					]);
					$member = app(\Modules\Member\Services\AuthService::class)->userRegister($request, $info, $type);

					$token = auth('api')->tokenById($member->uid);
					if($token){
						$this->data['data'] = [
							'access_token' => $token,
							'token_type' => 'bearer',
							'expires_in' => auth('api')->factory()->getTTL() * 60
						];
					}else{
						$this->data['message'] = "登录失败！";
						$this->data['code'] =0;
					}
				}else{
					$this->data['message'] = "登录失败！";
					$this->data['code'] = 0;
				}
			}
		}else{
			$this->data['message'] = "非法操作！";
			$this->data['code'] = 0;
		}
		return response()->json($this->data);
	}

	public function phone(Request $request, OauthService $service){
		try {
			$this->data['data'] = $service->getPhone($request);
		} catch (\Throwable $th) {
			$this->data['message'] = json_decode($th->getMessage())->errmsg;
			$this->data['code'] = $th->getCode();
		}

		return response()->json($this->data);
	}

	public function qrcode(Request $request, WechatService $service){
		try {
			$this->data['data'] = $service->getQrcode($request);
		} catch (\Throwable $th) {
			$this->data['message'] = $th->getMessage();
			$this->data['code'] = $th->getCode();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 微信公众号验证
	 *
	 * @param OauthService $service
	 * @return void
	 */
	public function serve(OauthService $service){
		return $service->serve();
	}

	/**
	* @title 获取微信jssdk配置
	*
	* @param WechatService $service
	* @return void
	*/
   public function jssdk(OauthService $service){
	   try {
		   $this->data['data'] = $service->getJsSdk($this->request);
	   } catch (\think\Exception $e) {
		   $this->data['message'] = $e->getMessage();
		   $this->data['code'] = 0;
	   }
	   return $this->data;
   }
}
