<?php

namespace Modules\System\Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class SystemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void {
		$this->insertSettingDict();
		$this->insertDataAuthDict();
		$this->insertAdsDict();
	}

	public function insertSettingDict(){
		$group_id = DB::table('system_dict_groups')->insertGetId([
			'parent_id'  => 0,
			'title'      => '配置分组',
			'name'       => 'setting_group',
			'status'     => 1,
			'created_at' => date('Y-m-d H:i:s'),
			'updated_at' => date('Y-m-d H:i:s'),
		]);
		if($group_id){
			$dict = DB::table('system_dicts')->insert([
				[
					'group_id'  => $group_id,
					'group_name' => 'setting_group',
					'title'     => '基础配置',
					'values'     => 'base',
					'sort'    => 1,
					'status'    => 1,
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				]
			]);
			DB::table('system_configs')->insert([
				[
					'name'      => 'system_name',
					'title'     => '系统名称',
					'values'     => 'SentOS',
					'type'      => 'string',
					'group' => 'base',
					'sort'    => 1,
					'status'    => 1,
					'remark'    => '系统名称',
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				],
				[
					'name'      => 'system_logo',
					'title'     => '系统Logo',
					'values'     => '',
					'type'      => 'image',
					'group' => 'base',
					'sort'    => 2,
					'status'    => 1,
					'remark'    => '系统Logo',
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				]
			]);
		}
	}

	public function insertDataAuthDict(){
		$group_id = DB::table('system_dict_groups')->insertGetId([
			'parent_id'  => 0,
			'title'      => '数据权限分组',
			'name'       => 'data_auth',
			'sort'    => 1,
			'status'    => 1,
			'created_at' => date('Y-m-d H:i:s'),
			'updated_at' => date('Y-m-d H:i:s'),
		]);
		if($group_id){
			DB::table('system_dicts')->insert([
				[
					'group_id'  => $group_id,
					'group_name' => 'data_auth',
					'title'     => '全部数据',
					'values'     => 'all',
					'sort'    => 1,
					'status'    => 1,
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				],
				[
					'group_id'  => $group_id,
					'group_name' => 'data_auth',
					'title'     => '本部门数据',
					'values'     => 'department',
					'sort'    => 2,
					'status'    => 1,
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				],
				[
					'group_id'  => $group_id,
					'group_name' => 'data_auth',
					'title'     => '本部门及以下数据',
					'values'     => 'department_sub',
					'sort'    => 3,
					'status'    => 1,
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				],
				[
					'group_id'  => $group_id,
					'group_name' => 'data_auth',
					'title'     => '仅自己数据',
					'values'     => 'self',
					'sort'    => 4,
					'status'    => 1,
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				]
			]);
		}
	}

	public function insertAdsDict(){
		$group_id = DB::table('system_dict_groups')->insertGetId([
			'parent_id'  => 0,
			'title'      => '广告位',
			'name'       => 'ads_places',
			'sort'    => 1,
			'status'    => 1,
			'created_at' => date('Y-m-d H:i:s'),
			'updated_at' => date('Y-m-d H:i:s'),
		]);
		if($group_id){
			DB::table('system_dicts')->insert([
				[
					'group_id'  => $group_id,
					'group_name' => 'ads_places',
					'title'     => '首页轮播',
					'values'     => 'index_banner',
					'sort'    => 1,
					'status'    => 1,
					'created_at' => date('Y-m-d H:i:s'),
					'updated_at' => date('Y-m-d H:i:s'),
				]
			]);
		}
	}
}
