<?php

namespace Modules\System\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\System\Models\Area;

class CitySeeder extends Seeder{
    /**
     * Run the database seeds.
     */
    public function run(): void {
		$area = json_decode(file_get_contents(module_path('System', 'database/seeders/area.json')), true);
		$data = [];
		foreach ($area as $value) {
			$value['created_at'] = date('Y-m-d H:i:s');
			$value['updated_at'] = date('Y-m-d H:i:s');
			$data[] = $value;
		}
		Area::insert($data);
	}
}
