<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Services;

use Modules\System\Models\Log;

class LogService {

	/**
	 * @title 获取日志列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request) {
		$map = [];

		if ($request->filled('title')) {
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if ($request->filled('name')) {
			$map[] = ['name', 'like', '%' . $request->input('name') . '%'];
		}
		if ($request->filled('url')) {
			$map[] = ['url', 'like', '%' . $request->input('url') . '%'];
		}
		if ($request->filled('method')) {
			$map[] = ['method', 'like', '%' . $request->input('method') . '%'];
		}
		if ($request->filled('ip')) {
			$map[] = ['ip', 'like', '%' . $request->input('ip') . '%'];
		}
		if ($request->filled('user_id')) {
			$map[] = ['user_id', '=', $request->input('user_id')];
		}
		if ($request->filled('data')) {
			$map[] = ['data', 'like', '%' . $request->input('data') . '%'];
		}
		if ($request->filled('remark')) {
			$map[] = ['remark', 'like', '%' . $request->input('remark') . '%'];
		}
		if ($request->filled('status')) {
			$map[] = ['status', '=', $request->input('status')];
		}
		if ($request->filled('is_my')) {
			$user = auth('admin')->user();
			$map[] = ['user_id', '=', $user->uid];
		}

		$query = Log::with(['user:nickname,username,uid'])->where($map)->orderBy('id', 'desc');

		$data = [
			'total' => $query->count(),
			'page' => $request->input('page', 1),
			'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
		];
		return $data;
	}

	public function createLog($request){
		list($class, $method) = explode('@', $request->route()->getActionName());
		$reflection = new \ReflectionMethod("\\" . $class, $method);
		$docComment = $reflection->getDocComment();
		$matches = [];
		preg_match("/@title(.*)(\\r\\n|\\r|\\n)/U", $docComment, $matches);

		$data = [
			'user_id' => auth('admin')->user()->uid,
			'title' => isset($matches[1]) ? trim($matches[1]) : '',
			'name' => $request->route()->getName() ?? '',
			'client_ip' => $request->ip(),
			'url' => $request->path(),
			'method' => $request->method(),
			'data' => json_encode($request->all()),
			'browser' => $request->userAgent(),
			'remark' => $request->input('remark', ''),
			'status' => 1,
		];
		$log = Log::create($data);

		return $log;
	}

	/**
	 * @title 删除日志
	 * @param Request $request
	 * @return bool
	 */
	public function delete($request){
		$map = [];
		if($request->filled('id')){
			$map[] = ['id', '=', $request->input('id')];
		}
		if($request->filled('ids')){
			$map[] = ['id', 'IN', $request->input('ids')];
		}
		if($request->filled('date')){
			$map[] = ['created_at', 'between', $request->input('date')];
		}

		if(empty($map)){
			throw new Exception("非法操作！", 1);
		}

		Log::where($map)->delete();
		return true;
	}
}
