<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\System\Services\LogService;

class Log extends BaseController {

	/**
	 * @title 日志列表
	 * @param Request $request
	 * @param LogService $service
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function index(Request $request, LogService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 我的日志列表
	 * @param Request $request
	 * @param LogService $service
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function my(Request $request, LogService $service){
		try {
			$request->merge(['is_my' => 1]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除日志
	 * @param Request $request
	 * @param LogService $service
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function delete(Request $request, LogService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
