<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

	public function up(): void {
		Schema::create('store_payment', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('order_no')->nullable()->comment('订单号');
			$table->unsignedBigInteger('store_id')->default(0)->comment('店铺ID');
			$table->unsignedBigInteger('member_id')->default(0)->comment('会员ID');
			$table->decimal('amount', total: 10, places: 2)->default(0)->comment('收款金额');
			$table->unsignedInteger('integral')->default(0)->comment('收款积分');
			$table->string('payment_type')->nullable()->comment('收款方式');
			$table->string('payment_sn')->nullable()->comment('收款单号');
			$table->string('payment_status')->nullable()->comment('收款状态');
			$table->string('payment_time')->nullable()->comment('收款时间');
			$table->string('payment_remark')->nullable()->comment('收款备注');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');
			$table->decimal('polymer_money', total: 10, places: 2)->default(0)->comment('聚物通');
			$table->string('pay_way')->nullable()->comment('付款方式');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('店铺收款表');
		});
	}

	public function down(): void{
		Schema::dropIfExists('store_payment');
	}
};