<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Models;

use App\Models\BaseModel;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Modules\Store\Observers\StoreObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;

#[ObservedBy([StoreObserver::class])]
class Store extends BaseModel {

	protected $table = 'store';
	protected $fillable = [];
	// protected $hidden = ['deleted_at'];

	protected function casts(): array {
		return [
			'photos' => 'json',
			'store_images' => 'json',
			'template'  => 'json',
			'status' => 'integer',
			'created_at' => 'datetime:Y-m-d H:i:s',
			'updated_at' => 'datetime:Y-m-d H:i:s',
		];
	}

	public function goods(){
		return $this->belongsToMany(\Modules\Goods\Models\Goods::class, 'store_goods', 'store_id', 'goods_id');
	}

	public function member(){
		return $this->belongsTo(\Modules\Member\Models\Member::class, 'member_id', 'uid');
	}

	public function service(){
		return $this->belongsTo(\Modules\Auth\Models\Admin::class, 'service_id', 'uid');
	}

	public function category(){
		return $this->hasOne(Category::class, 'id', 'category_id');
	}
}
