<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Order\Services\OrderService;

class Order extends BaseController {

	/**
	 * @title 订单列表
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function index(Request $request, OrderService $service){
		try {
			$request->mergeIfMissing(['is_store' => 1]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 订单详情
	 *
	 * @param Request $request
	 * @param \Modules\Order\Services\OrderService $service
	 * @return void
	 */
	public function detail(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->getDetailsData($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}
