<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Store\Services\StoreService;
use Modules\Auth\Services\UsersService;

class Index extends BaseController {

	/**
	 * @title 我访问的店铺
	 *
	 * @param Request $request
	 * @param StoreService $service
	 * @return void
	 */
	public function lists(Request $request, StoreService $service){
		try {
			$request->mergeIfMissing(['status' => 1]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 商品详情
	 *
	 * @param Request $request
	 * @param StoreService $service
	 * @return void
	 */
	public function detail(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->getData($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function mystore(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->mystore($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function service(Request $request, UsersService $service){
		try {
			$this->data['data'] = $service->getUserInfo($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function edit(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function count(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->getTrendCount($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	* @title 代理申请
	*
	* @return void
	*/
   public function apply(Request $request, StoreService $service){
	   try {
		   $this->data['data'] = $service->create($request);
	   } catch (\Throwable $e) {
		   $this->data['code'] = 0;
		   $this->data['message']  = $e->getMessage();
	   }
	   return $this->data;
   }
}
