<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
		Schema::create('cart', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('member_id')->comment('用户ID');
			$table->unsignedBigInteger('store_id')->comment('店铺ID');
			$table->unsignedBigInteger('goods_id')->comment('商品ID');
			$table->unsignedBigInteger('goods_sku_id')->comment('商品SKU ID');
			$table->integer('num')->default(0)->comment('商品数量');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('购物车表');
		});
		Schema::create('order', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('order_no')->comment('订单号');
			$table->unsignedBigInteger('member_id')->comment('用户ID');
			$table->unsignedBigInteger('invite_uid')->comment('邀请购买人UID');
			$table->decimal('amount', total: 10, places: 2)->default(0)->comment('订单总金额');
			$table->unsignedInteger('integral')->default(0)->comment('积分');
			$table->string('pay_type')->default('wechat')->comment('支付方式');
			$table->string('pay_no')->nullable()->comment('支付单号');
			$table->tinyInteger('status')->default(1)->comment('订单状态 0待支付 1待发货 2待收货 3已完成 4退款中 5已退款 6已关闭');
			$table->timestamp('pay_time')->nullable()->comment('支付时间');
			$table->text('delivery_info')->nullable()->comment('配送收货人信息');
			$table->string('confirm_time')->nullable()->comment('确认收货时间');
			$table->string('comment_time')->nullable()->comment('评价时间');
			$table->string('close_time')->nullable()->comment('关闭时间');
			$table->string('refund_time')->nullable()->comment('退款时间');
			$table->string('refund_no')->nullable()->comment('退款单号');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');
			$table->string('delivery_type')->nullable()->comment('配送方式');
			$table->softDeletes();

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品订单表');
		});
		Schema::create('order_item', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('order_id')->comment('订单ID');
			$table->unsignedBigInteger('member_id')->comment('用户ID');
			$table->unsignedBigInteger('store_id')->comment('店铺ID');
			$table->unsignedBigInteger('goods_id')->comment('商品ID');
			$table->unsignedBigInteger('goods_sku_id')->comment('商品SKU ID');
			$table->string('title')->nullable()->comment('商品标题');
			$table->string('cover')->nullable()->comment('商品图片');
			$table->decimal('price', total: 10, places: 2)->default(0)->comment('商品价格');
			$table->decimal('discount_price', total: 10, places: 2)->default(0)->comment('商品优惠价格');
			$table->unsignedInteger('integral')->default(0)->comment('积分');
			$table->integer('num')->default(0)->comment('商品数量');
			$table->decimal('total_price', total: 10, places: 2)->default(0)->comment('商品总价');
			$table->unsignedInteger('total_integral')->default(0)->comment('商品总积分');
			$table->string('delivery_type')->nullable()->comment('配送方式');
			$table->string('delivery_no')->nullable()->comment('配送单号');
			$table->string('delivery_time')->nullable()->comment('发货时间');
			$table->tinyInteger('status')->default(0)->comment('订单状态 0待支付 1待发货 2待收货 3已完成 4退款中 5已退款 6已关闭');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品订单详情表');
		});
		Schema::create('order_refund', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('refund_no')->comment('退款单号');
			$table->unsignedBigInteger('order_id')->comment('订单ID');
			$table->unsignedBigInteger('store_id')->comment('店铺ID');
			$table->unsignedBigInteger('member_id')->comment('用户ID');
			$table->unsignedBigInteger('order_item_id')->comment('订单详情ID');
			$table->unsignedBigInteger('goods_id')->comment('商品ID');
			$table->unsignedBigInteger('goods_sku_id')->comment('商品SKU ID');
			$table->string('reason')->comment('退款原因');
			$table->string('out_refund_no')->nullable()->comment('退款订单号');
			$table->string('images')->nullable()->comment('退款图片');
			$table->string('remark')->nullable()->comment('退款备注说明');
			$table->decimal('amount', total: 10, places: 2)->default(0)->comment('退款金额');
			$table->tinyInteger('status')->default(1)->comment('退款状态 1待审核 2已同意 3已拒绝 4已完成');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品订单退款表');
		});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
		Schema::dropIfExists('cart');
		Schema::dropIfExists('order');
		Schema::dropIfExists('order_item');
		Schema::dropIfExists('order_refund');
    }
};
