<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Models;

use App\Models\BaseModel;

class Refund extends BaseModel {

	protected $table = 'order_refund';

	protected $fillable = ['order_id', 'member_id', 'reason', 'images', 'amount', 'status'];

	protected function casts(): array {
		return [
			'created_at' => 'datetime:Y-m-d H:i:s',
			'updated_at' => 'datetime:Y-m-d H:i:s',
		];
	}

	public function member(){
		return $this->belongsTo(\Modules\Member\Models\Member::class, 'member_id', 'uid');
	}

	public function goods(){
		return $this->belongsTo(\Modules\Goods\Models\Goods::class, 'goods_id', 'id');
	}

	public function sku(){
		return $this->belongsTo(\Modules\Goods\Models\GoodsSku::class, 'goods_sku_id', 'id');
	}

	public function order(){
		return $this->belongsTo(Order::class, 'order_id', 'id');
	}

	public function item(){
		return $this->hasMany(OrderItem::class, 'id', 'order_item_id');
	}
}
