<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Models;

use App\Models\BaseModel;

class Order extends BaseModel {

	protected $table = 'order';
	protected $fillable = ['order_no', 'store_id', 'member_id', 'invite_uid', 'amount', 'pay_type', 'pay_no', 'delivery_type', 'delivery_no', 'delivery_info', 'status', 'pay_time', 'confirm_time', 'comment_time', 'close_time', 'refund_time', 'refund_no','delivery_type'];
	// protected $hidden = ['deleted_at'];

	protected function casts(): array {
		return [
			'delivery_info' => 'json',
			'status' => 'integer',
			'created_at' => 'datetime:Y-m-d H:i:s',
			'updated_at' => 'datetime:Y-m-d H:i:s',
		];
	}

	public function detail(){
		return $this->hasMany(OrderItem::class, 'order_id', 'id');
	}

	public function member(){
		return $this->belongsTo('Modules\Member\Models\Member', 'member_id', 'uid');
	}

	public function store(){
		return $this->belongsTo('Modules\Store\Models\Store', 'store_id', 'id');
	}

	public function refund(){
		return $this->hasOne(Refund::class, 'order_id', 'id');
	}
}
