<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Order\Services\CartService;

class Cart extends BaseController {

	/**
	 * @title 购物车列表
	 *
	 * @param Request $request
	 * @param CartService $service
	 * @return void
	 */
	public function index(Request $request, CartService $service){
		try {
			$this->data['data'] = $service->getDataList(auth('api')->user()['uid']);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加购物车
	 *
	 * @param Request $request
	 * @param CartService $service
	 * @return void
	 */
	public function add(Request $request, CartService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 更新购物车
	 *
	 * @param Request $request
	 * @param CartService $service
	 * @return void
	 */
	public function edit(Request $request, CartService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除购物车
	 *
	 * @param Request $request
	 * @param CartService $service
	 * @return void
	 */
	public function delete(Request $request, CartService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}