<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Order\Services\OrderService;

class Order extends BaseController {

	/**
	 * @title 商品列表
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function index(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 商品详情
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function detail(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->getData($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加商品
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function add(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改商品
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function edit(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除商品
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function delete(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 发货
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function send(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->orderSend($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
