<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Services;

use Modules\Member\Models\MemberLevel;

class LevelService {

	/**
	 * @title 获取会员列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request){
		$map = [];

		if ($request->filled('title')) {
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if ($request->filled('name')) {
			$map[] = ['name', 'like', '%' . $request->input('name') . '%'];
		}
		$query = MemberLevel::where($map)->orderBy('id', 'desc');

		$data = [
			'total' => $query->count(),
			'page' => $request->input('page', 1),
			'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
		];
		return $data;
	}

	/**
	 * @title 添加会员
	 *
	 * @param Request $request
	 * @param MemberService $service
	 * @return void
	 */
	public function create($request){
		$request->validate([
			'title' => 'required|max:255',
			'name' => 'required|max:255|alpha_dash:ascii|unique:member_level,name',
		]);

		$data = [
			'title' => $request->input('title', ''),
			'name' => $request->input('name', ''),
			'icon' => $request->input('icon', ''),
			'sort' => $request->input('sort', 0),
			'status' => $request->input('status', 1),
			'remark' => $request->input('remark', ''),
		];

		$level = MemberLevel::create($data);
	}

	/**
	 * @title 修改会员
	 *
	 * @param Request $request
	 * @param MemberService $service
	 * @return void
	 */
	public function update($request){
		$request->validate([
			'title' => 'required|max:255',
			'name' => 'required|max:255|alpha_dash:ascii|unique:member_level,name,' . $request->input('id'),
		]);

		try {
			$level = MemberLevel::findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("会员不存在！", 1);
		}

		$data = [
			'title'=> $request->input('title', ''),
			'name' => $request->input('name', ''),
			'icon' => $request->input('icon', ''),
			'sort' => $request->input('sort', 0),
			'status' => $request->input('status', 1),
			'remark' => $request->input('remark', ''),
		];
		$level->update($data);
		return $level;
	}

	public function delete($request){
		if($request->filled('id')){
			try {
				$level = MemberLevel::findOrFail($request->input('id'));
			} catch (\Throwable $th) {
				throw new \Exception("会员等级不存在！", 1);
			}
			$level->members()->detach();
			$level->delete();
		}
		if($request->filled('ids')){
			try {
				$level = MemberLevel::whereIn('id', $request->input('ids'));
				foreach ($level->get() as $item) {
					$item->members()->detach();   //删除关联
				}
				$level->delete();
			} catch (\Throwable $th) {
				throw new \Exception($th->getMessage(), 1);
			}
		}

		return $level;
	}
}
