<?php


namespace Modules\Member\Controllers\Api;


use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use Modules\Member\Services\SignService;

class Sign extends BaseController
{

	/*
	 * 签到记录
	 */
	public function index(Request $request,SignService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**签到
	 * @param Request $request
	 * @param SignService $service
	 * @return array
	 */
	public function add(Request $request,SignService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return $this->data;
	}
}