<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\PromoterService;
use Modules\Order\Services\OrderService;
use Modules\Store\Services\StoreService;

class Promoter extends BaseController {

	public function apply(Request $request, PromoterService $service){
		try {
			$service->create($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function detail(Request $request, PromoterService $service){
		try {
			$this->data['data'] = $service->getDetail($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function info(Request $request, PromoterService $service){
		try {
			$this->data['data'] = $service->getInfo($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function order(Request $request, OrderService $service){
		try {
			$request->mergeIfMissing([
				'is_invite' => 1,
				'pro_status' => 0,
			]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function store(Request $request, StoreService $service){
		try {
			$request->mergeIfMissing([
				'is_invite' => 1,
			]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}