<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\PolymerService;

class Polymer extends BaseController {

	/**
	 * @title 聚物通列表
	 *
	 * @param PolymerService $service
	 * @return void
	 */
	public function index(Request $request, PolymerService $service){
		try {
			$request->mergeIfMissing([
				'is_user' => 1
			]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\think\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return $this->data;
	}
}
