<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\CollectService;

class Collect extends BaseController {
	/**
	 * @title 收藏列表
	 *
	 * @return void
	 */
	public function index(Request $request, CollectService $service){
		$request->mergeIfMissing(
			['is_user' => 1]
		);

		$this->data['data'] = $service->getDataList($request);

		return $this->data;
	}

	public function add(Request $request, CollectService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return $this->data;
	}

	/**
	 * @title 删除关注
	 *
	 * @param Request $request
	 * @param CollectService $service
	 * @return void
	 */
	public function delete(Request $request, CollectService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return $this->data;
	}
}
